/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Export symbols for tracing module (tracedev)
 *
 * Define new global variables with GPFS_EXPORT_SYMBOL(varname).
 * Define new functions with GPFS_EXPORT_FUNC(varname).
 *
 * The latter will automatically spit out a generic function
 * prototype. The prototype format doesn't matter here, but
 * it is important to let the compiler know that something
 * is really a function (or else incorrect code is spewed out
 * on IA64 for the relocation entry which trips up insmod;
 * the i386 platform doesn't have this feature).
 *
 *
 * $Id: tracedev-ksyms.c,v 1.8 2001/07/19 23:25:06 dcraft Exp $
 *
 * $Log: tracedev-ksyms.c,v $
 * Revision 1.8  2001/07/19 23:25:06  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.7  2001/06/14 18:14:11  gjertsen
 * Initial changes for IA64 beta RH 7.1 with 2.4.3-3 kernel. Get GPFS_PRINTF
 * working again.
 *
 * Revision 1.6  2001/04/20 18:55:31  gjertsen
 * Minor tweak to get rid of compiler warnings.
 *
 * Revision 1.5  2001/01/29 19:39:02  eshel
 * export lxthe only ifndef GPFS_PRINTF
 *
 * Revision 1.4  2001/01/27 20:37:50  dcraft
 * Move trace device header definition so it can be used by lcrash
 * Export header symbol.
 *
 * Revision 1.3  2000/12/15 13:56:51  gjertsen
 * Clean up documentation.
 *
 * Revision 1.2  2000/11/06 19:56:18  gjertsen
 * Linux code cleanup. Add build safeguards.
 *
 * Revision 1.1  2000/10/26 20:52:49  gjertsen
 * Purge out ugly USE_CWRAPPERS and export module symbols explicitly
 * as the default (in IA64 safe manner).
 *
 *
 */

#include <linux/version.h>
#include <linux/module.h>
#define GPFS_GPL

#if defined(MODULE) && defined(GPFS_EXPORT_KSYMS)

/* Use GPFS_EXPORT_SYMBOL for exporting a variable */
/* Use GPFS_EXPORT_FUNC for exporting a function */
#define GPFS_EXPORT_SYMBOL(VAR) extern VAR; EXPORT_SYMBOL_NOVERS(VAR);
#define GPFS_EXPORT_FUNC(FNAME) extern void FNAME (); \
                                EXPORT_SYMBOL_NOVERS(FNAME);


/* ************** */
/* Export section */
/* ************** */
#ifndef GPFS_PRINTF
GPFS_EXPORT_FUNC(_STrace);
GPFS_EXPORT_FUNC(_STraceNB);
GPFS_EXPORT_FUNC(_XTrace);
GPFS_EXPORT_FUNC(_XTraceNB);
GPFS_EXPORT_SYMBOL(lxthe);
GPFS_EXPORT_FUNC(trc_fsync);
#endif /* ! GPFS_PRINTF */

#endif /* MODULE && GPFS_EXPORT_KSYMS */
